CREATE DATABASE LigaKreglarskaPrzyklad
GO

use LigaKreglarskaPrzyklad
GO

CREATE TABLE Wyniki_kreglarzy (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDKreglarza int NOT NULL ,
	WynikCzysty smallint NULL ,
	WynikHandicap smallint NULL ,
	GraWygrana bit NOT NULL 
) 
GO

CREATE TABLE Kreglarze (
	IDKreglarza int NOT NULL ,
	NazwiskoKreglarza nvarchar (50) NULL ,
	ImieKreglarza nvarchar (50) NULL ,
	SrodkowyInicjalKreglarza nvarchar (1) NULL ,
	AdresKreglarza nvarchar (50) NULL ,
	MiastoKreglarza nvarchar (50) NULL ,
	StanZamKreglarza nvarchar (2) NULL ,
	KodPocztowyKreglarza nvarchar (10) NULL ,
	TelefonKreglarza nvarchar (14) NULL ,
	IDDruzyny int NULL 
) 
GO

CREATE TABLE Gry_meczowe (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDWygranejDruzyny int NULL 
) 
GO

CREATE TABLE Druzyny (
	IDDruzyny int NOT NULL ,
	NazwaDruzyny nvarchar (50) NOT NULL ,
	IDKapitana int NULL 
) 
GO

CREATE TABLE Turnieje (
	IDTurnieju int NOT NULL ,
	DataTurnieju date NULL ,
	LokalizacjaTurnieju nvarchar (50) NULL 
) 
GO

CREATE TABLE Mecze_turniejowe (
	IDMeczu int NOT NULL ,
	IDTurnieju int NULL ,
	Tory nvarchar (5) NULL ,
	IDDruzynyTorNieparzysty int NULL ,
	IDDruzynyTorParzysty int NULL 
) 
GO

CREATE TABLE ztblPoziomKreglarza (
        PoziomKreglarza nvarchar (15) NOT NULL , 
        SredniaNiskaKreglarza smallint NULL ,
        SredniaWysokaKreglarza smallint NULL 
)
GO

CREATE TABLE ztblPomijanieEtykiet ( 
        LicznikEtykiet int NOT NULL 
)
GO

CREATE TABLE ztblTygodnie (
        PoczatekTygodnia date NOT NULL ,
        KoniecTygodnia date NULL 
)
GO

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT WK_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT WK_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT WK_ID_kreglarza_domyslny DEFAULT (0) FOR IDKreglarza,
	CONSTRAINT WK_wynik_czysty_domyslny DEFAULT (0) FOR WynikCzysty,
	CONSTRAINT WK_wynik_handicap_domyslny DEFAULT (0) FOR WynikHandicap,
	CONSTRAINT WK_gra_wygrana_domyslny DEFAULT (0) FOR GraWygrana,
	CONSTRAINT Wyniki_kreglarzy_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry,
		IDKreglarza
	)   
GO

CREATE  INDEX IDKreglarza ON Wyniki_kreglarzy(IDKreglarza) 
GO

CREATE  INDEX GryMeczoweWynikiKreglarzy ON Wyniki_kreglarzy(IDMeczu, NumerGry) 
GO

ALTER TABLE Kreglarze ADD 
	CONSTRAINT ID_kreglara_domyslny DEFAULT (0) FOR IDKreglarza,
	CONSTRAINT Kreglarze_PK PRIMARY KEY   
	(
		IDKreglarza
	)   
GO

CREATE  INDEX NazwiskoKreglarza ON Kreglarze(NazwiskoKreglarza) 
GO

CREATE  INDEX KreglarzeIDDruzyny ON Kreglarze(IDDruzyny) 
GO

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT GM_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT GM_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT GM_wygrana_druzyna_domyslny DEFAULT (0) FOR IDWygranejDruzyny,
	CONSTRAINT Gry_meczowe_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry
	)   
GO

CREATE  INDEX IDDruzyny1 ON Gry_meczowe(IDWygranejDruzyny) 
GO

CREATE  INDEX MeczeTurniejoweGryMeczowe ON Gry_meczowe(IDMeczu) 
GO

ALTER TABLE Druzyny ADD 
        CONSTRAINT ID_druzyny_domyslny DEFAULT (0) FOR IDDruzyny,
	CONSTRAINT Druzyny_PK PRIMARY KEY   
	(
		IDDruzyny
	)   
GO

ALTER TABLE Turnieje ADD 
	CONSTRAINT ID_turnieju_domyslny DEFAULT (0) FOR IDTurnieju,
	CONSTRAINT Turnieje_PK PRIMARY KEY   
	(
		IDTurnieju
	)   
GO

ALTER TABLE Mecze_turniejowe ADD 
	CONSTRAINT MT_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT MT_ID_turnieju_domyslny DEFAULT (0) FOR IDTurnieju,
	CONSTRAINT MT_druzyna_tor_nieparzysty_domyslny DEFAULT (0) FOR IDDruzynyTorNieparzysty,
	CONSTRAINT MT_druzyna_tor_parzysty_domyslny DEFAULT (0) FOR IDDruzynyTorParzysty,
	CONSTRAINT Mecze_turniejowe_PK PRIMARY KEY   
	(
		IDMeczu
	)   
GO

CREATE  INDEX DruzynyMecze_turniejowe ON Mecze_turniejowe(IDDruzynyTorParzysty) 
GO

CREATE  INDEX DruzynyMeczeTurniejowe ON Mecze_turniejowe(IDDruzynyTorNieparzysty) 
GO

CREATE  INDEX TurniejeMeczeTurniejowe ON Mecze_turniejowe(IDTurnieju) 
GO

CREATE  INDEX IDTurnieju ON Mecze_turniejowe(IDTurnieju) 
GO

ALTER TABLE ztblPoziomKreglarza ADD 
        CONSTRAINT ztblPoziomKreglarza_PK PRIMARY KEY 
        ( 
                PoziomKreglarza 
        ) 
GO

ALTER TABLE ztblPomijanieEtykiet ADD 
        CONSTRAINT ztblPomijanieEtykiet_PK PRIMARY KEY 
        ( 
                LicznikEtykiet 
        )
GO

ALTER TABLE ztblTygodnie ADD
        CONSTRAINT ztblTygodnie_PK PRIMARY KEY 
        ( 
                PoczatekTygodnia 
        )
GO

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT Wyniki_kreglarzy_FK00 FOREIGN KEY 
	(
		IDKreglarza
	) REFERENCES Kreglarze (
		IDKreglarza
	),
	CONSTRAINT Wyniki_kreglarzy_FK01 FOREIGN KEY 
	(
		IDMeczu,
		NumerGry
	) REFERENCES Gry_meczowe (
		IDMeczu,
		NumerGry
	)
GO

ALTER TABLE Kreglarze ADD 
	CONSTRAINT Kreglarze_FK00 FOREIGN KEY 
	(
		IDDruzyny
	) REFERENCES Druzyny (
		IDDruzyny
	)
GO

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT Gry_meczowe_FK00 FOREIGN KEY 
	(
		IDMeczu
	) REFERENCES Mecze_turniejowe (
		IDMeczu
	)
GO

ALTER TABLE Mecze_turniejowe ADD 
	CONSTRAINT Mecze_turniejowe_FK00 FOREIGN KEY 
	(
		IDDruzynyTorParzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	CONSTRAINT Mecze_turniejowe_FK01 FOREIGN KEY 
	(
		IDDruzynyTorNieparzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	CONSTRAINT Mecze_turniejowe_FK02 FOREIGN KEY 
	(
		IDTurnieju
	) REFERENCES Turnieje (
		IDTurnieju
	)
GO